<!DOCTYPE xsl:stylesheet  [
<!ENTITY ndash "&#8211;">
]>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:m1="http://www.sec.gov/edgar/sdrfiler"
	xmlns:ns1="http://www.sec.gov/edgar/common" xmlns:n1="http://www.sec.gov/edgar/common_drp"
	xmlns:ns2="http://www.sec.gov/edgar/statecodes" xmlns:ns3="http://www.sec.gov/edgar/sdrcommon">

	<!-- Item 6 templates -->
	<xsl:template name="Item6">
		<h3>
			<em>Not Applicable Exhibits
			</em>
		</h3>
		<xsl:call-template name="nonapplicableExhibits" />
	</xsl:template>

	<xsl:template name="nonapplicableExhibits">
		<xsl:for-each select="m1:nonapplicableExhibits">
			<h4>
				<em>Not Applicable Exhibits:
				</em>
			</h4>
			<table role="presentation" >
				<tr>
					<td class="label">Not Applicable Exhibits :  </td>
					<td>
						<p>
							<div align="left">
								<div class="fakeBox3">
									<xsl:value-of select="m1:exhibit/m1:nonapplicableExhibitType" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">Not Applicable Reason :  </td>
					<td>
						<p>
							<div align="left">
								<div class="fakeBox3">
									<xsl:value-of select="m1:exhibit/m1:nonapplicableJustification" />
									<span>
										<xsl:text>&#160;</xsl:text>
									</span>
								</div>
							</div>
						</p>
					</td>
				</tr>
				<tr>
					<td class="label">
						Request Confidentiality:
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="(m1:exhibit/m1:confidential) = 'true'">
								<img src="Images/box-checked.jpg" alt="Checkbox checked" />
							</xsl:when>
							<xsl:otherwise>
								<img src="Images/box-unchecked.jpg" alt="Checkbox not checked" />
							</xsl:otherwise>
						</xsl:choose>
					</td>
				</tr>
			</table>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>